(function($) {
    'use strict';
    if (typeof woonutriPdfExport === 'undefined') {
        return;
    }

    var WooNutriPdfExport = {

        
        init: function() {
            this.bindEvents();
            this.initLabelSizeDescription();
        },

        
        bindEvents: function() {
            var self = this;
            $(document).on('change', '.product-checkbox', self.updateSelectedCount);
            $(document).on('change', '#select-all-products', self.toggleSelectAll);
            $(document).on('change', '#label-size', self.handleLabelSizeChange);
            $(document).on('change', '#label-template', self.updatePreview);
            $(document).on('change', '.product-checkbox', self.updatePreview);
            $(document).on('click', '#export-single-pdf', self.exportSinglePdf);
            $(document).on('click', '#export-batch-pdf', self.exportBatchPdf);
            $(document).on('click', '.woonutri-admin-export-pdf', self.exportFromProductPage);
            $(document).on('click', '.woonutri-export-pdf-btn', self.exportFromFrontend);
            $(document).on('change', '#include-allergens, #include-ingredients, #include-nutri-score, #include-product-header', self.updatePreview);
        },

        
        initLabelSizeDescription: function() {
            var $sizeSelect = $('#label-size');
            if ($sizeSelect.length) {
                this.updateSizeDescription($sizeSelect.val());
            }
        },

        
        updateSelectedCount: function() {
            var count = $('.product-checkbox:checked').length;
            $('#selected-product-count').text(count);
        },

        
        toggleSelectAll: function() {
            var isChecked = $(this).is(':checked');
            $('.product-checkbox').prop('checked', isChecked);
            WooNutriPdfExport.updateSelectedCount();
        },

        
        handleLabelSizeChange: function() {
            var size = $(this).val();
            WooNutriPdfExport.updateSizeDescription(size);
            if (size === 'custom') {
                $('#custom-size-fields').slideDown();
            } else {
                $('#custom-size-fields').slideUp();
            }

            WooNutriPdfExport.updatePreview();
        },

        
        updateSizeDescription: function(size) {
            var sizes = woonutriPdfExport.label_sizes;
            if (sizes && sizes[size]) {
                $('.size-description').text(sizes[size].description);
            }
        },

        
        updatePreview: function() {
            var $preview = $('#label-preview');
            if (!$preview.length) {
                return;
            }
            var productId = $('.product-checkbox:checked').first().val();
            if (!productId) {
                $preview.html('<p style="color: #666; text-align: center;">' + woonutriPdfExport.i18n.select_products + '</p>');
                return;
            }

            $preview.html('<p style="text-align: center;"><span class="spinner is-active" style="float: none;"></span> Loading preview...</p>');

            $.ajax({
                url: woonutriPdfExport.ajax_url,
                type: 'POST',
                data: {
                    action: 'woonutri_preview_pdf',
                    nonce: woonutriPdfExport.nonce,
                    product_id: productId,
                    template: $('#label-template').val(),
                    include_allergens: $('#include-allergens').is(':checked'),
                    include_ingredients: $('#include-ingredients').is(':checked'),
                    include_nutri_score: $('#include-nutri-score').is(':checked')
                },
                success: function(response) {
                    if (response.success) {
                        $preview.html('<div class="preview-wrapper" style="max-width: 300px; margin: 0 auto;">' + response.data.html + '</div>');
                    } else {
                        $preview.html('<p style="color: #d63638; text-align: center;">' + (response.data.message || 'Error loading preview') + '</p>');
                    }
                },
                error: function() {
                    $preview.html('<p style="color: #d63638; text-align: center;">Error loading preview</p>');
                }
            });
        },

        
        exportSinglePdf: function(e) {
            e.preventDefault();

            var productId = $('.product-checkbox:checked').first().val();
            if (!productId) {
                alert(woonutriPdfExport.i18n.select_products);
                return;
            }

            WooNutriPdfExport.generatePdf(productId, $(this));
        },

        
        exportBatchPdf: function(e) {
            e.preventDefault();

            var productIds = [];
            $('.product-checkbox:checked').each(function() {
                productIds.push($(this).val());
            });

            if (productIds.length === 0) {
                alert(woonutriPdfExport.i18n.select_products);
                return;
            }

            var $btn = $(this);
            var originalText = $btn.html();
            $btn.prop('disabled', true).html('<span class="spinner is-active" style="float: none; margin: 0 5px 0 0;"></span>' + woonutriPdfExport.i18n.generating);

            $.ajax({
                url: woonutriPdfExport.ajax_url,
                type: 'POST',
                data: {
                    action: 'woonutri_export_pdf_batch',
                    nonce: woonutriPdfExport.nonce,
                    product_ids: productIds,
                    size: $('#label-size').val(),
                    template: $('#label-template').val(),
                    labels_per_page: 1
                },
                success: function(response) {
                    if (response.success) {

                        window.open(response.data.url, '_blank');
                        WooNutriPdfExport.showNotice('success', woonutriPdfExport.i18n.batch_complete + ' (' + response.data.count + ' labels)');
                    } else if (response.data && response.data.upgrade) {

                        WooNutriPdfExport.showUpgradeModal(response.data);
                    } else {
                        WooNutriPdfExport.showNotice('error', response.data.message || woonutriPdfExport.i18n.error);
                    }
                },
                error: function() {
                    WooNutriPdfExport.showNotice('error', woonutriPdfExport.i18n.error);
                },
                complete: function() {
                    $btn.prop('disabled', false).html(originalText);
                }
            });
        },

        
        exportFromProductPage: function(e) {
            e.preventDefault();

            var $btn = $(this);
            var productId = $btn.data('product-id');
            var nonce = $btn.data('nonce');

            if (!productId) {
                return;
            }

            var originalText = $btn.html();
            $btn.prop('disabled', true).html('<span class="spinner is-active" style="float: none; margin: 0;"></span>');

            $.ajax({
                url: woonutriPdfExport.ajax_url,
                type: 'POST',
                data: {
                    action: 'woonutri_export_pdf',
                    nonce: nonce,
                    product_id: productId,
                    size: $('#admin-export-size').val() || 'medium',
                    template: $('#admin-export-template').val() || 'standard',
                    include_allergens: true,
                    include_ingredients: true
                },
                success: function(response) {
                    if (response.success) {
                        window.open(response.data.url, '_blank');
                    } else if (response.data && response.data.upgrade) {
                        WooNutriPdfExport.showUpgradeModal(response.data);
                    } else {
                        alert(response.data.message || woonutriPdfExport.i18n.error);
                    }
                },
                error: function() {
                    alert(woonutriPdfExport.i18n.error);
                },
                complete: function() {
                    $btn.prop('disabled', false).html(originalText);
                }
            });
        },

        
        exportFromFrontend: function(e) {
            e.preventDefault();

            var $btn = $(this);
            var productId = $btn.data('product-id');
            var nonce = $btn.data('nonce');

            if (!productId) {
                return;
            }

            var originalText = $btn.html();
            $btn.prop('disabled', true).text(woonutriPdfExport.i18n.generating);

            $.ajax({
                url: woonutriPdfExport.ajax_url,
                type: 'POST',
                data: {
                    action: 'woonutri_export_pdf',
                    nonce: nonce,
                    product_id: productId,
                    size: 'medium',
                    template: 'standard',
                    include_allergens: true,
                    include_ingredients: true
                },
                success: function(response) {
                    if (response.success) {
                        window.open(response.data.url, '_blank');
                    } else if (response.data && response.data.upgrade) {
                        WooNutriPdfExport.showUpgradeModal(response.data);
                    } else {
                        alert(response.data.message || woonutriPdfExport.i18n.error);
                    }
                },
                error: function() {
                    alert(woonutriPdfExport.i18n.error);
                },
                complete: function() {
                    $btn.prop('disabled', false).html(originalText);
                }
            });
        },

        
        generatePdf: function(productId, $btn) {
            var originalText = $btn.html();
            $btn.prop('disabled', true).html('<span class="spinner is-active" style="float: none; margin: 0 5px 0 0;"></span>' + woonutriPdfExport.i18n.generating);

            var data = {
                action: 'woonutri_export_pdf',
                nonce: woonutriPdfExport.nonce,
                product_id: productId,
                size: $('#label-size').val(),
                template: $('#label-template').val(),
                dpi: $('#dpi').val(),
                include_bleed: $('#include-bleed').is(':checked'),
                include_crop_marks: $('#include-crop-marks').is(':checked'),
                include_product_header: $('#include-product-header').is(':checked'),
                include_allergens: $('#include-allergens').is(':checked'),
                include_ingredients: $('#include-ingredients').is(':checked'),
                include_nutri_score: $('#include-nutri-score').is(':checked'),
                include_barcode_area: $('#include-barcode-area').is(':checked'),
                include_regulatory: $('#include-regulatory').is(':checked')
            };
            if (data.size === 'custom') {
                data.custom_width = $('#custom-width').val();
                data.custom_height = $('#custom-height').val();
            }

            $.ajax({
                url: woonutriPdfExport.ajax_url,
                type: 'POST',
                data: data,
                success: function(response) {
                    if (response.success) {
                        window.open(response.data.url, '_blank');
                        WooNutriPdfExport.showNotice('success', 'PDF generated successfully!');
                    } else if (response.data && response.data.upgrade) {

                        WooNutriPdfExport.showUpgradeModal(response.data);
                    } else {
                        WooNutriPdfExport.showNotice('error', response.data.message || woonutriPdfExport.i18n.error);
                    }
                },
                error: function() {
                    WooNutriPdfExport.showNotice('error', woonutriPdfExport.i18n.error);
                },
                complete: function() {
                    $btn.prop('disabled', false).html(originalText);
                }
            });
        },

        
        showUpgradeModal: function(data) {
            var modalHtml = '<div class="woonutri-upgrade-modal" style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.6); z-index: 100000; display: flex; align-items: center; justify-content: center;">' +
                '<div style="background: white; padding: 40px; border-radius: 12px; max-width: 450px; text-align: center; box-shadow: 0 4px 20px rgba(0,0,0,0.3);">' +
                '<div style="font-size: 48px; margin-bottom: 15px;">🔒</div>' +
                '<h2 style="margin: 0 0 10px 0;">' + (data.feature_name || 'Pro Feature') + '</h2>' +
                '<p style="color: #666; margin-bottom: 20px;">' + (data.feature_description || data.message) + '</p>' +
                '<a href="' + data.upgrade_url + '" class="button button-primary button-hero" style="margin-right: 10px;">Upgrade to Pro</a>' +
                '<button type="button" class="button button-large woonutri-close-modal">Maybe Later</button>' +
                '</div></div>';

            $('body').append(modalHtml);

            $('.woonutri-close-modal, .woonutri-upgrade-modal').on('click', function(e) {
                if (e.target === this || $(this).hasClass('woonutri-close-modal')) {
                    $('.woonutri-upgrade-modal').remove();
                }
            });
        },

        
        showNotice: function(type, message) {
            var $notice = $('<div class="notice notice-' + type + ' is-dismissible" style="margin-top: 15px;"><p>' + message + '</p></div>');
            $('.woonutri-export-actions .notice').remove();
            $('.woonutri-export-actions').after($notice);
            setTimeout(function() {
                $notice.fadeOut(function() {
                    $(this).remove();
                });
            }, 5000);
        }
    };
    $(document).ready(function() {
        WooNutriPdfExport.init();
    });

})(jQuery);
