
(function($) {
    'use strict';

    const WooNutriWizard = {
        init: function() {
            this.bindEvents();
            this.initSelections();
        },

        bindEvents: function() {

            $(document).on('change', '.woonutri-region-card input', this.handleRegionChange);
            $(document).on('change', '.woonutri-display-option input', this.handleDisplayChange);
            $(document).on('change', '.woonutri-theme-card input', this.handleThemeChange);
            $(document).on('click', '.woonutri-wizard-next', this.handleNext);
            $(document).on('click', '.woonutri-wizard-complete', this.handleComplete);
            $(document).on('click', '.woonutri-wizard-skip', this.handleSkip);
            $(document).on('click', '.woonutri-region-card', function(e) {
                if (!$(e.target).is('input')) {
                    $(this).find('input').prop('checked', true).trigger('change');
                }
            });

            $(document).on('click', '.woonutri-display-option', function(e) {
                if (!$(e.target).is('input')) {
                    $(this).find('input').prop('checked', true).trigger('change');
                }
            });

            $(document).on('click', '.woonutri-theme-card:not(.locked)', function(e) {
                if (!$(e.target).is('input')) {
                    $(this).find('input').prop('checked', true).trigger('change');
                }
            });
        },

        initSelections: function() {

            this.updateCardSelection('.woonutri-region-card');
            this.updateCardSelection('.woonutri-display-option');
            this.updateCardSelection('.woonutri-theme-card');
        },

        updateCardSelection: function(selector) {
            $(selector).removeClass('selected');
            $(selector + ' input:checked').closest(selector).addClass('selected');
        },

        handleRegionChange: function() {
            WooNutriWizard.updateCardSelection('.woonutri-region-card');
        },

        handleDisplayChange: function() {
            WooNutriWizard.updateCardSelection('.woonutri-display-option');
        },

        handleThemeChange: function() {
            WooNutriWizard.updateCardSelection('.woonutri-theme-card');
        },

        handleNext: function(e) {
            e.preventDefault();
            const $btn = $(this);
            const step = $btn.data('step');

            $btn.prop('disabled', true).text(woonutriWizard.i18n.saving);

            const data = {
                action: 'woonutri_save_wizard_step',
                nonce: woonutriWizard.nonce,
                step: step
            };
            switch (step) {
                case 1:
                    data.region = $('input[name="woonutri_region"]:checked').val();
                    break;
                case 2:
                    data.display = $('input[name="woonutri_display"]:checked').val();
                    break;
                case 3:
                    data.theme = $('input[name="woonutri_theme"]:checked').val();
                    break;
            }

            $.post(woonutriWizard.ajax_url, data, function(response) {
                if (response.success) {
                    window.location.href = response.data.next_url;
                } else {
                    alert(response.data.message || woonutriWizard.i18n.error);
                    $btn.prop('disabled', false).html(woonutriWizard.i18n.next + ' &rarr;');
                }
            }).fail(function() {
                alert(woonutriWizard.i18n.error);
                $btn.prop('disabled', false).html(woonutriWizard.i18n.next + ' &rarr;');
            });
        },

        handleComplete: function(e) {
            e.preventDefault();
            const $btn = $(this);
            const step = $btn.data('step');

            $btn.prop('disabled', true).text(woonutriWizard.i18n.saving);

            $.post(woonutriWizard.ajax_url, {
                action: 'woonutri_complete_wizard',
                nonce: woonutriWizard.nonce,
                step: step
            }, function(response) {
                if (response.success) {
                    window.location.href = response.data.redirect_url;
                } else {
                    alert(response.data.message || woonutriWizard.i18n.error);
                    $btn.prop('disabled', false).html(woonutriWizard.i18n.complete + ' &check;');
                }
            }).fail(function() {
                alert(woonutriWizard.i18n.error);
                $btn.prop('disabled', false).html(woonutriWizard.i18n.complete + ' &check;');
            });
        },

        handleSkip: function(e) {
            e.preventDefault();
            const $btn = $(this);

            if (!confirm('Are you sure you want to skip the setup? You can configure settings manually later.')) {
                return;
            }

            $btn.prop('disabled', true).text(woonutriWizard.i18n.saving);

            $.post(woonutriWizard.ajax_url, {
                action: 'woonutri_skip_wizard',
                nonce: woonutriWizard.nonce
            }, function(response) {
                if (response.success) {
                    window.location.href = response.data.redirect_url;
                } else {
                    alert(response.data.message || woonutriWizard.i18n.error);
                    $btn.prop('disabled', false).text('Skip Setup');
                }
            }).fail(function() {
                alert(woonutriWizard.i18n.error);
                $btn.prop('disabled', false).text('Skip Setup');
            });
        }
    };

    $(document).ready(function() {
        WooNutriWizard.init();
    });

})(jQuery);
