<?php
class Woonutri_Nutrition_Templates
{

    public static function get_templates()
    {
        return [
            'soft_drink' => [
                'name' => __('Soft Drink / Soda', 'smart-nutrition-labels'),
                'category' => __('Beverages', 'smart-nutrition-labels'),
                'icon' => '🥤',
                'serving_size' => '330ml',
                'data' => [
                    'energy_kcal' => 139,
                    'energy_kj' => 581,
                    'fat' => 0,
                    'saturated_fat' => 0,
                    'carbohydrates' => 35,
                    'sugar' => 35,
                    'fiber' => 0,
                    'protein' => 0,
                    'salt' => 0.02,
                ],
            ],
            'fruit_juice' => [
                'name' => __('Fruit Juice (100%)', 'smart-nutrition-labels'),
                'category' => __('Beverages', 'smart-nutrition-labels'),
                'icon' => '🧃',
                'serving_size' => '250ml',
                'data' => [
                    'energy_kcal' => 115,
                    'energy_kj' => 480,
                    'fat' => 0.3,
                    'saturated_fat' => 0,
                    'carbohydrates' => 26,
                    'sugar' => 23,
                    'fiber' => 0.5,
                    'protein' => 0.8,
                    'salt' => 0.01,
                    'vitamin_c' => 60,
                ],
            ],
            'energy_drink' => [
                'name' => __('Energy Drink', 'smart-nutrition-labels'),
                'category' => __('Beverages', 'smart-nutrition-labels'),
                'icon' => '⚡',
                'serving_size' => '250ml',
                'data' => [
                    'energy_kcal' => 112,
                    'energy_kj' => 470,
                    'fat' => 0,
                    'saturated_fat' => 0,
                    'carbohydrates' => 27,
                    'sugar' => 27,
                    'fiber' => 0,
                    'protein' => 0,
                    'salt' => 0.18,
                    'caffeine' => 80,
                ],
            ],
            'milk' => [
                'name' => __('Whole Milk', 'smart-nutrition-labels'),
                'category' => __('Beverages', 'smart-nutrition-labels'),
                'icon' => '🥛',
                'serving_size' => '250ml',
                'data' => [
                    'energy_kcal' => 160,
                    'energy_kj' => 669,
                    'fat' => 8.8,
                    'saturated_fat' => 5.5,
                    'carbohydrates' => 12,
                    'sugar' => 12,
                    'fiber' => 0,
                    'protein' => 8.5,
                    'salt' => 0.25,
                    'calcium' => 300,
                ],
            ],

            'chocolate_bar' => [
                'name' => __('Chocolate Bar (Milk)', 'smart-nutrition-labels'),
                'category' => __('Snacks', 'smart-nutrition-labels'),
                'icon' => '🍫',
                'serving_size' => '40g',
                'data' => [
                    'energy_kcal' => 214,
                    'energy_kj' => 894,
                    'fat' => 12,
                    'saturated_fat' => 7.2,
                    'carbohydrates' => 23,
                    'sugar' => 22,
                    'fiber' => 0.8,
                    'protein' => 3.2,
                    'salt' => 0.1,
                ],
            ],
            'potato_chips' => [
                'name' => __('Potato Chips / Crisps', 'smart-nutrition-labels'),
                'category' => __('Snacks', 'smart-nutrition-labels'),
                'icon' => '🥔',
                'serving_size' => '30g',
                'data' => [
                    'energy_kcal' => 159,
                    'energy_kj' => 665,
                    'fat' => 10,
                    'saturated_fat' => 1,
                    'carbohydrates' => 15,
                    'sugar' => 0.3,
                    'fiber' => 1.2,
                    'protein' => 1.8,
                    'salt' => 0.4,
                ],
            ],
            'protein_bar' => [
                'name' => __('Protein Bar', 'smart-nutrition-labels'),
                'category' => __('Snacks', 'smart-nutrition-labels'),
                'icon' => '💪',
                'serving_size' => '60g',
                'data' => [
                    'energy_kcal' => 210,
                    'energy_kj' => 878,
                    'fat' => 7,
                    'saturated_fat' => 3.5,
                    'carbohydrates' => 22,
                    'sugar' => 5,
                    'fiber' => 4,
                    'protein' => 20,
                    'salt' => 0.3,
                ],
            ],
            'cookies' => [
                'name' => __('Cookies / Biscuits', 'smart-nutrition-labels'),
                'category' => __('Snacks', 'smart-nutrition-labels'),
                'icon' => '🍪',
                'serving_size' => '30g (2 cookies)',
                'data' => [
                    'energy_kcal' => 148,
                    'energy_kj' => 619,
                    'fat' => 7,
                    'saturated_fat' => 3.5,
                    'carbohydrates' => 20,
                    'sugar' => 10,
                    'fiber' => 0.8,
                    'protein' => 1.8,
                    'salt' => 0.2,
                ],
            ],

            'breakfast_cereal' => [
                'name' => __('Breakfast Cereal', 'smart-nutrition-labels'),
                'category' => __('Breakfast', 'smart-nutrition-labels'),
                'icon' => '🥣',
                'serving_size' => '30g',
                'data' => [
                    'energy_kcal' => 114,
                    'energy_kj' => 477,
                    'fat' => 0.5,
                    'saturated_fat' => 0.1,
                    'carbohydrates' => 25,
                    'sugar' => 8,
                    'fiber' => 2.5,
                    'protein' => 2,
                    'salt' => 0.3,
                    'iron' => 4.2,
                ],
            ],
            'granola' => [
                'name' => __('Granola', 'smart-nutrition-labels'),
                'category' => __('Breakfast', 'smart-nutrition-labels'),
                'icon' => '🌾',
                'serving_size' => '45g',
                'data' => [
                    'energy_kcal' => 195,
                    'energy_kj' => 815,
                    'fat' => 8,
                    'saturated_fat' => 1.5,
                    'carbohydrates' => 25,
                    'sugar' => 9,
                    'fiber' => 4,
                    'protein' => 5,
                    'salt' => 0.05,
                ],
            ],
            'yogurt' => [
                'name' => __('Greek Yogurt', 'smart-nutrition-labels'),
                'category' => __('Breakfast', 'smart-nutrition-labels'),
                'icon' => '🥛',
                'serving_size' => '150g',
                'data' => [
                    'energy_kcal' => 150,
                    'energy_kj' => 627,
                    'fat' => 7.5,
                    'saturated_fat' => 5,
                    'carbohydrates' => 6,
                    'sugar' => 6,
                    'fiber' => 0,
                    'protein' => 15,
                    'salt' => 0.15,
                    'calcium' => 180,
                ],
            ],

            'bread' => [
                'name' => __('White Bread', 'smart-nutrition-labels'),
                'category' => __('Bakery', 'smart-nutrition-labels'),
                'icon' => '🍞',
                'serving_size' => '30g (1 slice)',
                'data' => [
                    'energy_kcal' => 79,
                    'energy_kj' => 330,
                    'fat' => 1,
                    'saturated_fat' => 0.2,
                    'carbohydrates' => 15,
                    'sugar' => 1.5,
                    'fiber' => 0.8,
                    'protein' => 2.7,
                    'salt' => 0.4,
                ],
            ],
            'wholegrain_bread' => [
                'name' => __('Wholegrain Bread', 'smart-nutrition-labels'),
                'category' => __('Bakery', 'smart-nutrition-labels'),
                'icon' => '🥖',
                'serving_size' => '35g (1 slice)',
                'data' => [
                    'energy_kcal' => 81,
                    'energy_kj' => 339,
                    'fat' => 1.2,
                    'saturated_fat' => 0.2,
                    'carbohydrates' => 13,
                    'sugar' => 1.8,
                    'fiber' => 3,
                    'protein' => 4,
                    'salt' => 0.35,
                ],
            ],

            'whey_protein' => [
                'name' => __('Whey Protein Powder', 'smart-nutrition-labels'),
                'category' => __('Supplements', 'smart-nutrition-labels'),
                'icon' => '🏋️',
                'serving_size' => '30g (1 scoop)',
                'data' => [
                    'energy_kcal' => 120,
                    'energy_kj' => 502,
                    'fat' => 1.5,
                    'saturated_fat' => 0.8,
                    'carbohydrates' => 2,
                    'sugar' => 1,
                    'fiber' => 0,
                    'protein' => 24,
                    'salt' => 0.2,
                ],
            ],
            'vitamins' => [
                'name' => __('Multivitamin Tablet', 'smart-nutrition-labels'),
                'category' => __('Supplements', 'smart-nutrition-labels'),
                'icon' => '💊',
                'serving_size' => '1 tablet',
                'data' => [
                    'energy_kcal' => 2,
                    'vitamin_a' => 800,
                    'vitamin_c' => 80,
                    'vitamin_d' => 5,
                    'vitamin_e' => 12,
                    'vitamin_b6' => 1.4,
                    'vitamin_b12' => 2.5,
                    'iron' => 14,
                    'zinc' => 10,
                ],
            ],

            'pasta_meal' => [
                'name' => __('Pasta Ready Meal', 'smart-nutrition-labels'),
                'category' => __('Ready Meals', 'smart-nutrition-labels'),
                'icon' => '🍝',
                'serving_size' => '400g',
                'data' => [
                    'energy_kcal' => 520,
                    'energy_kj' => 2175,
                    'fat' => 18,
                    'saturated_fat' => 8,
                    'carbohydrates' => 65,
                    'sugar' => 8,
                    'fiber' => 4,
                    'protein' => 20,
                    'salt' => 1.8,
                ],
            ],
            'salad' => [
                'name' => __('Mixed Salad (no dressing)', 'smart-nutrition-labels'),
                'category' => __('Ready Meals', 'smart-nutrition-labels'),
                'icon' => '🥗',
                'serving_size' => '150g',
                'data' => [
                    'energy_kcal' => 30,
                    'energy_kj' => 125,
                    'fat' => 0.5,
                    'saturated_fat' => 0.1,
                    'carbohydrates' => 4,
                    'sugar' => 3,
                    'fiber' => 2.5,
                    'protein' => 2,
                    'salt' => 0.02,
                    'vitamin_c' => 25,
                ],
            ],
        ];
    }

    public static function get_templates_by_category()
    {
        $templates = self::get_templates();
        $grouped = [];

        foreach ($templates as $id => $template) {
            $category = $template['category'];
            if (!isset($grouped[$category])) {
                $grouped[$category] = [];
            }
            $grouped[$category][$id] = $template;
        }

        return $grouped;
    }

    public static function get_template($template_id)
    {
        $templates = self::get_templates();
        return isset($templates[$template_id]) ? $templates[$template_id] : null;
    }

    public static function apply_template($template_id, $product_id)
    {
        $template = self::get_template($template_id);

        if (!$template || !$product_id) {
            return false;
        }

        $profiles = get_post_meta($product_id, '_woonutri_profiles', true);

        if (empty($profiles)) {
            $profiles = [[]];
        }

        $profiles[0] = array_merge($profiles[0], $template['data']);

        if (!empty($template['serving_size'])) {
            $profiles[0]['serving_size'] = $template['serving_size'];
        }

        update_post_meta($product_id, '_woonutri_profiles', $profiles);

        foreach ($template['data'] as $key => $value) {
            update_post_meta($product_id, '_woonutri_' . $key, $value);
        }

        return true;
    }

    public static function render_template_selector($field_id = 'woonutri_template')
    {
        $grouped = self::get_templates_by_category();

        $html = '<select id="' . esc_attr($field_id) . '" name="' . esc_attr($field_id) . '" class="woonutri-template-selector">';
        $html .= '<option value="">' . esc_html__('— Select a template —', 'smart-nutrition-labels') . '</option>';

        foreach ($grouped as $category => $templates) {
            $html .= '<optgroup label="' . esc_attr($category) . '">';

            foreach ($templates as $id => $template) {
                $html .= sprintf(
                    '<option value="%s" data-icon="%s">%s %s</option>',
                    esc_attr($id),
                    esc_attr($template['icon']),
                    $template['icon'],
                    esc_html($template['name'])
                );
            }

            $html .= '</optgroup>';
        }

        $html .= '</select>';
        $html .= '<button type="button" class="button woonutri-apply-template" title="' . esc_attr__('Apply this template to fill in nutrition values', 'smart-nutrition-labels') . '">';
        $html .= esc_html__('Apply Template', 'smart-nutrition-labels');
        $html .= '</button>';

        return $html;
    }

    public static function get_styles()
    {
        return '
        .woonutri-template-selector {
            min-width: 200px;
            padding: 6px 10px;
            border-radius: 4px;
            border: 1px solid #8c8f94;
            margin-right: 8px;
        }

        .woonutri-apply-template {
            vertical-align: middle;
        }

        .woonutri-template-info {
            margin-top: 8px;
            padding: 10px;
            background: #f0f6fc;
            border: 1px solid #c3c4c7;
            border-radius: 4px;
            font-size: 13px;
        }
        ';
    }
}
