<?php
/**
 * Plugin Name: Smart Nutrition Labels for WooCommerce
 * Plugin URI: https://woonutri.com/
 * Description: Add professional nutrition facts labels to your WooCommerce products. Supports FDA, EU, UK, Australia & Canada formats with 35+ themes, 14 allergens, and PDF export.
 * Version: 1.0.0
 * Author: WooNutri
 * Author URI: https://woonutri.com/
 * Text Domain: smart-nutrition-labels
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 9.0
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit;
}

if (function_exists('woonutri_fs')) {
    woonutri_fs()->set_basename(true, __FILE__);
} else {
    if (!function_exists('woonutri_fs')) {
        function woonutri_fs()
        {
            global $woonutri_fs;

            if (!isset($woonutri_fs)) {
                require_once dirname(__FILE__) . '/vendor/freemius/start.php';
                $woonutri_fs = fs_dynamic_init(array(
                    'id' => '19986',
                    'slug' => 'woonutri--smart-nutrition-facts-for-woocommerce',
                    'type' => 'plugin',
                    'public_key' => 'pk_95aebc8a3e9b6f3e3e5000336b8c2',
                    'is_premium' => true,
                    'premium_suffix' => 'Starter',
                    'has_premium_version' => true,
                    'has_addons' => false,
                    'has_paid_plans' => true,
                    'menu' => array(
                        'slug' => 'woonutri-settings',
                        'first-path' => 'admin.php?page=woonutri-settings',
                        'support' => false,
                    ),
                ));
            }

            return $woonutri_fs;
        }

        woonutri_fs();
        do_action('woonutri_fs_loaded');
    }

    define('WOONUTRI_VERSION', '1.1.0');
    define('WOONUTRI_PLUGIN_FILE', __FILE__);
    define('WOONUTRI_PLUGIN_DIR', plugin_dir_path(__FILE__));
    define('WOONUTRI_PLUGIN_URL', plugin_dir_url(__FILE__));
    define('WOONUTRI_BASENAME', plugin_basename(__FILE__));
    define('WOONUTRI_TEXTDOMAIN', 'smart-nutrition-labels');

    add_action('init', function () {
        load_plugin_textdomain('smart-nutrition-labels', false, dirname(WOONUTRI_BASENAME) . '/languages');
    });

    if (!defined('WOONUTRI_DEV_MODE')) {
        define('WOONUTRI_DEV_MODE', false);
    }

    function woonutri_is_pro() {
        if (defined('WOONUTRI_DEV_MODE') && WOONUTRI_DEV_MODE) {
            $allowed_dev_hosts = ['localhost', '127.0.0.1', '::1'];
            $server_name = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : '';
            $server_addr = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : '';

            $is_local = in_array($server_name, $allowed_dev_hosts)
                || in_array($server_addr, $allowed_dev_hosts)
                || preg_match('/\.(local|test|localhost)$/', $server_name)
                || (defined('WP_DEBUG') && WP_DEBUG && defined('WP_LOCAL_DEV') && WP_LOCAL_DEV);

            if ($is_local) {
                return true;
            }
        }

        return woonutri_fs()->can_use_premium_code__premium_only();
    }

    function woonutri_show_pro_ui() {
        return true;
    }

    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-cache.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-meta-handler.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-pro-features.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-label-standards.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-allergens.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-nutri-score.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-analytics.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-traffic-lights.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-nutrition-templates.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-schema-output.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/core/class-pdf-export.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/admin/class-admin-ui.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/frontend/class-label-renderer.php';

    require_once WOONUTRI_PLUGIN_DIR . 'includes/frontend/class-product-comparison.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/admin/class-settings.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/admin/class-setup-wizard.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/admin/class-dashboard.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/admin/class-bulk-operations.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/admin/class-variation-admin.php';
    require_once WOONUTRI_PLUGIN_DIR . 'includes/blocks/class-gutenberg-blocks.php';

    if (woonutri_fs()->can_use_premium_code__premium_only()) {

        if (file_exists(WOONUTRI_PLUGIN_DIR . 'includes/api/class-nutrition-api.php')) {
            require_once WOONUTRI_PLUGIN_DIR . 'includes/api/class-nutrition-api.php';
        }
    }

    register_activation_hook(__FILE__, 'woonutri_plugin_activate');
    function woonutri_plugin_activate()
    {
        set_transient('woonutri_activation_redirect', true, 30);
    }

    add_action('init', function () {
        if (is_admin()) {
            \Woonutri_Admin_UI::init();
            \Woonutri_Settings::init();
            \Woonutri_Setup_Wizard::init();
            \Woonutri_Dashboard::init();
            \Woonutri_Bulk_Operations::init();
        }

        \Woonutri_Analytics::init();

        \Woonutri_Gutenberg_Blocks::init();

        if (woonutri_fs()->can_use_premium_code__premium_only()) {

            if (class_exists('Woonutri_Nutrition_API')) {
                \Woonutri_Nutrition_API::init();
            }
        }
    });

    add_action('wp', function () {
        \Woonutri_Label_Renderer::init();
    }, 5);

    add_action('init', function () {
        \Woonutri_Schema_Output::init();
    });

    add_action('init', function () {
        if (woonutri_fs()->can_use_premium_code__premium_only()) {
            \Woonutri_Product_Comparison::init();
        }
    });

    add_action('init', function () {
        \Woonutri_PDF_Export::init();
    });

    add_action('init', function () {
        add_shortcode('nutrition_facts', ['Woonutri_Label_Renderer', 'shortcode']);
    });

    add_action('woocommerce_init', function () {
        $instance = \Woonutri_Label_Renderer::get_instance();
        if (!is_admin() || wp_doing_ajax()) {
            $instance->init_display_hooks();
        }
    }, 99);

    woonutri_fs()->add_action('after_uninstall', 'woonutri_fs_uninstall_cleanup');

    function woonutri_fs_uninstall_cleanup()
    {
        delete_option('woonutri_options');

        global $wpdb;
        $wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE 'woonutri_%'");

        if (class_exists('Woonutri_Cache')) {
            Woonutri_Cache::flush();
        }
    }
}
